package com.agilex.healthcare.directscheduling.domain;


import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: patelh
 * Date: 8/28/13
 * Time: 12:31 PM
 * To change this template use File | Settings | File Templates.
 */
@XmlRootElement(name = "facility", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlType(namespace = Namespace.DirectScheduling)
public class SchedulingFacility  extends DomainTransferObject {

    private static final long serialVersionUID = 7039746531936746360L;

    @XmlElement
    private String siteCode;
    @XmlElement
    private String name;
    @XmlElement
    private String displayName;
    @XmlElement
    private String regionId;
    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlElement
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date lastEventTimestamp;
    @XmlElement
    private String lastEventReason;
    @XmlElement
    private String uid;
    @XmlElement
    private String pid;
    @XmlElement
    private String type;
    @XmlElement
    private String facilityCode;
    @XmlElement
    private String state;
    @XmlElement
    private String city;
    @XmlElement
    private String address;
    @XmlElement
    private String parentSiteCode;


    public String getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getRegionId() {
        return regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public Date getLastEventTimestamp() {
        return lastEventTimestamp;
    }

    public void setLastEventTimestamp(Date lastEventTimestamp) {
        this.lastEventTimestamp = lastEventTimestamp;
    }

    public String getLastEventReason() {
        return lastEventReason;
    }

    public void setLastEventReason(String lastEventReason) {
        this.lastEventReason = lastEventReason;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFacilityCode() {
        return facilityCode;
    }

    public void setFacilityCode(String facilityCode) {
        this.facilityCode = facilityCode;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getParentSiteCode() {
        return parentSiteCode;
    }

    public void setParentSiteCode(String parentSiteCode) {
        this.parentSiteCode = parentSiteCode;
    }
}
